using System;
using System.Collections.Generic;

class T
{
    public int x { get; set; }
    public int v { get; set; }
}

class Program
{
    static void Main()
    {
        string[] s = Console.ReadLine().Split(' ');
        int N, K;
        N = int.Parse(s[0]);
        K = int.Parse(s[1]);

        List<T> trkaci = new List<T>();
        for (int i = 0; i < N; i++)
        {
            s = Console.ReadLine().Split(' ');
            trkaci.Add(new T { x = int.Parse(s[0]), v = int.Parse(s[1]) });
        }

        // Step 1: Calculate Time to Overtake and store in preticanja
        double[] preticanja = CalculateOvertakingTimes(trkaci);

        // Step 2: Remove zeroes and negative numbers from preticanja
        preticanja = RemoveZeroesAndNegatives(preticanja);

        // Step 3: Sort the preticanja
        Array.Sort(preticanja);
        int n = 0;
        double t = 0;
        for (int i = 0; i < preticanja.Length; i++)
        {
            if (preticanja[i] > t)
            {
                n++;
                if (n == K)
                {
                    Console.WriteLine(preticanja[i].ToString("F9"));
                    break;
                }
                t = preticanja[i];
            }
        }
        foreach (var item in preticanja)
        {
            Console.WriteLine(item.ToString("F9"));
        }
    }

    static double[] CalculateOvertakingTimes(List<T> trkaci)
    {
        double[] preticanja = new double[(trkaci.Count * (trkaci.Count - 1))];
        int index = 0;

        for (int i = 0; i < trkaci.Count; i++)
        {
            for (int j = 0; j < trkaci.Count; j++)
            {
                if (i != j && trkaci[i].x < trkaci[j].x)
                {
                    double timeToOvertake = (double)(trkaci[j].x - trkaci[i].x) / (trkaci[i].v - trkaci[j].v);
                    preticanja[index++] = timeToOvertake;
                }
            }
        }

        return preticanja;
    }

    static double[] RemoveZeroesAndNegatives(double[] array)
    {
        List<double> nonZeroesAndPositives = new List<double>();

        foreach (var item in array)
        {
            if (item > 0)
            {
                nonZeroesAndPositives.Add(item);
            }
        }

        return nonZeroesAndPositives.ToArray();
    }
}